/******************************************************************************
 CBkgndTask.h

			Header File For CBkgndTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#pragma once

#include <Processes.h>
#include <CObject.h>
#include "config.h"		// used for error codes

typedef enum { kFront, kGen, kBind, kExec } CompilerPart;

// Background Tasks Management - this class helps maintain the tasks
// that execute in the background (compile, bind, etc).

class CBkgndTask : public CObject {

  protected:
	CBkgndTask	*next;

	CompilerPart	partId;

	Str255		procPath;		/* path to the background process */
	Str255		procName;		/* file name of the background process */
	Str255		procFullName;
	FSSpec		bkgndPgm;
	ProcessSerialNumber procNum;

	int			errorCode;		// RC_SUCCESS, RC_ERRORS, RC_INTERNAL_ERROR,
								// RC_ABORT == user interrupted

	public:
	
				void	IBkgndTask(Str255 name);
		virtual	void	Dispose(void);

	protected:
				void	SetPartID(CompilerPart part);
	public:
				CompilerPart	PartID(void);
		
				void		SetNext(CBkgndTask *p);
				CBkgndTask *GetNext(void);


		virtual	void	StartRunning(void);
		virtual	void	WriteOptions(void);
		virtual	Boolean	StillRunning(void);

		virtual	int		ReadCompletionCode(void);
		virtual	int		CompletionCode(void);

		virtual	void	AnnounceWithSound(void);
		virtual	void	Cleanup(void);
		virtual	void	InternalError(void);
		virtual	void	CompilerError(void);
		virtual	void	NoError(void);
};

